/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRadioButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.hifi.HiFiUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public class HiFiRadioButtonUI
extends BaseRadioButtonUI {
    private static HiFiRadioButtonUI radioButtonUI = null;

    public static ComponentUI createUI(JComponent c2) {
        if (radioButtonUI == null) {
            radioButtonUI = new HiFiRadioButtonUI();
        }
        return radioButtonUI;
    }

    protected void paintText(Graphics g2, JComponent c2, String text, Rectangle textRect) {
        View v = (View)c2.getClientProperty("html");
        if (v != null) {
            v.paint(g2, textRect);
        } else {
            AbstractButton b2 = (AbstractButton)c2;
            ButtonModel model = b2.getModel();
            int mnemIndex = -1;
            mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b2.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b2.getText(), model.getMnemonic());
            g2.setFont(b2.getFont());
            FontMetrics fm = JTattooUtilities.getFontMetrics(b2, g2, b2.getFont());
            if (model.isEnabled()) {
                Color fc = b2.getForeground();
                if (AbstractLookAndFeel.getTheme().isTextShadowOn() && ColorHelper.getGrayValue(fc) > 128) {
                    g2.setColor(Color.black);
                    JTattooUtilities.drawStringUnderlineCharAt(c2, g2, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
                }
                g2.setColor(fc);
                JTattooUtilities.drawStringUnderlineCharAt(c2, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g2.setColor(Color.black);
                JTattooUtilities.drawStringUnderlineCharAt(c2, g2, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
                g2.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                JTattooUtilities.drawStringUnderlineCharAt(c2, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    public void paintBackground(Graphics g2, JComponent c2) {
        if (c2.isOpaque()) {
            if (c2.getBackground() instanceof ColorUIResource && c2.getBackground().equals(AbstractLookAndFeel.getBackgroundColor())) {
                HiFiUtils.fillComponent(g2, c2);
            } else {
                g2.setColor(c2.getBackground());
                g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
            }
        }
    }
}

